<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Test\Integration;

use Amasty\ReportBuilder\Test\Registry;
use Magento\TestFramework\Helper\Bootstrap;
use PHPUnit\Framework\TestCase;

/**
 * Test load virtual column, saved by fixture.
 *
 * @magentoAppArea adminhtml
 * @magentoAppIsolation disabled
 * @magentoDbIsolation disabled
 * @magentoDataFixtureBeforeTransaction Amasty_ReportBuilder::Test/_files/report.php
 * @magentoDataFixtureBeforeTransaction Amasty_ReportBuilderVirtual::Test/_files/virtual_column.php
 */
class SaveLoadTest extends TestCase
{
    /**
     * @var \Amasty\ReportBuilder\Model\Report\ColumnProvider
     */
    private $provider;

    protected function setUp(): void
    {
        parent::setUp();

        $this->provider = Bootstrap::getObjectManager()->get(\Amasty\ReportBuilder\Model\Report\ColumnProvider::class);
    }

    /**
     * @magentoAppIsolation disabled
     * @magentoDbIsolation disabled
     */
    public function testLoadVirtual(): void
    {
        $reportId = Registry::$REPORT_ID;
        $columns = $this->provider->getColumnsByReportId($reportId);
        self::assertArrayHasKey('virtual_1', $columns);
        self::assertArrayHasKey('virtual_2', $columns);

        self::assertSame(
            'decimal',
            $columns['virtual_1']->getExtensionAttributes()->getVirtualColumn()->getDataType()
        );

        self::assertSame(
            'string',
            $columns['virtual_2']->getExtensionAttributes()->getVirtualColumn()->getDataType()
        );
    }
}
