<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Test\Integration\Model\Context;

use Amasty\ReportBuilder\Api\Data\ReportInterface;
use Amasty\ReportBuilder\Model\Report\ColumnProvider;
use Amasty\ReportBuilder\Model\ReportRepository;
use Amasty\ReportBuilder\Test\Registry;
use Amasty\ReportBuilderVirtual\Model\Backend\Report\DataCollector\Entity\VirtualColumnsEntity;
use Magento\TestFramework\Helper\Bootstrap;
use PHPUnit\Framework\TestCase;

/**
 * @magentoAppArea adminhtml
 * @magentoAppIsolation disabled
 * @magentoDbIsolation disabled
 * @magentoDataFixtureBeforeTransaction Amasty_ReportBuilder::Test/_files/report.php
 * @magentoDataFixtureBeforeTransaction Amasty_ReportBuilderVirtual::Test/_files/virtual_column.php
 */
class VirtualColumnsEntityTest extends TestCase
{
    /**
     * @var ReportInterface
     */
    private $report;

    /**
     * @var VirtualColumnsEntity
     */
    private $model;

    /**
     * @var ColumnProvider
     */
    private $columnProvider;

    protected function setUp(): void
    {
        parent::setUp();

        /** @var ReportRepository $repository */
        $repository = Bootstrap::getObjectManager()->get(ReportRepository::class);
        $this->report = $repository->getById(Registry::$REPORT_ID);
        $this->model = Bootstrap::getObjectManager()->get(VirtualColumnsEntity::class);
        $this->columnProvider = Bootstrap::getObjectManager()->get(ColumnProvider::class);
    }

    /**
     * @covers VirtualColumnsEntity::collect
     *
     * @dataProvider dataProvider
     *
     * @magentoAppIsolation disabled
     * @magentoDbIsolation disabled
     *
     * @param array $relations
     * @param array $expected
     */
    public function testCollect(array $relations, array $expected): void
    {
        $report = $this->report;
        $reportColumn = $this->columnProvider->getColumnsByReportId($report->getReportId())['virtual_1'];
        $this->model->collect($report, $reportColumn, $relations);

        self::assertEquals($expected, $relations);
    }

    public function dataProvider(): array
    {
        return [
            'init' => [
                [],
                [
                    [
                        ReportInterface::SCHEME_SOURCE_ENTITY => 'order',
                        ReportInterface::SCHEME_ENTITY => 'order_item'
                    ]
                ]
            ],
            'exist' => [
                [
                    [
                        ReportInterface::SCHEME_SOURCE_ENTITY => 'order',
                        ReportInterface::SCHEME_ENTITY => 'order_item'
                    ]
                ],
                [
                    [
                        ReportInterface::SCHEME_SOURCE_ENTITY => 'order',
                        ReportInterface::SCHEME_ENTITY => 'order_item'
                    ]
                ]
            ]
        ];
    }
}
