<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Plugin\ReportBuilder\Model\SelectResolver\ColumnFilter\FilterColumn;

use Amasty\ReportBuilder\Model\Report\ColumnsResolver;
use Amasty\ReportBuilder\Model\SelectResolver\ColumnFilter\FilterColumn;
use Amasty\ReportBuilder\Model\SelectResolver\ColumnResolverInterface;

class VirtualColumnAggregated
{
    /**
     * @var ColumnsResolver
     */
    private $columnsResolver;

    public function __construct(ColumnsResolver $columnsResolver)
    {
        $this->columnsResolver = $columnsResolver;
    }

    /**
     * @param FilterColumn $subject
     * @param bool $result
     * @param string $filter
     *
     * @return bool
     */
    public function afterIsFilterUsesAggregation(
        FilterColumn $subject,
        bool $result,
        string $filter
    ): bool {
        if (!$result) {
            return $result;
        }

        $selectColumn = $subject->getSelectColumnByFilter($filter);
        
        if ($selectColumn == null) {
            return $result;
        }

        $reportColumn = $this->columnsResolver->getReportColumns()[$selectColumn->getColumnId()];
        $virtualColumn = $reportColumn->getExtensionAttributes()->getVirtualColumn();
        if ($virtualColumn !== null) {
            return false;
        }

        return $result;
    }
}
