<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Plugin\ReportBuilder\Model\SelectResolver\ColumnBuilder;

use Amasty\ReportBuilder\Api\Data\SelectColumnInterface;
use Amasty\ReportBuilder\Model\ResourceModel\Report\Data\Select;
use Amasty\ReportBuilder\Model\SelectResolver\ColumnBuilder;
use Amasty\ReportBuilderVirtual\Model\SelectResolver\SelectColumn\SelectVirtualColumn;

/**
 * Virtual column should be rendered last.
 */
class VirtualColumnToEnd
{
    /**
     * Move virtual column before rendering Select column.
     *
     * Context of virtual columns can't have own aggregation type.
     * They should use the same aggregation as a root columns in case if the root column exits in the Report.
     *
     * @param ColumnBuilder $subject
     * @param Select $select
     * @param SelectColumnInterface[] $columns
     * @return array
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeBuildSelectColumn(ColumnBuilder $subject, Select $select, array $columns): array
    {
        usort($columns, [$this, 'virtualToEnd']);

        return [$select, $columns];
    }

    private function virtualToEnd(SelectColumnInterface $leftColumn, SelectColumnInterface $rightColumn): int
    {
        $leftType = $leftColumn->getType();
        $rightType = $rightColumn->getType();

        if ($leftType === $rightType) {
            return 0;
        }

        if ($leftType === SelectVirtualColumn::TYPE_VIRTUAL) {
            return 1;
        }

        if ($rightType === SelectVirtualColumn::TYPE_VIRTUAL) {
            return -1;
        }

        return 0;
    }
}
