<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Plugin\ReportBuilder\Model\Report\ColumnSave;

use Amasty\ReportBuilder\Model\Report\Column;
use Amasty\ReportBuilder\Model\Report\ColumnSave;
use Amasty\ReportBuilderVirtual\Model\ReportVirtualColumn;
use Amasty\ReportBuilderVirtual\Model\ResourceModel\ReportVirtualColumn as ReportVirtualResource;

class SaveVirtualColumns
{
    /**
     * @var ReportVirtualResource
     */
    private $resource;

    public function __construct(ReportVirtualResource $resource)
    {
        $this->resource = $resource;
    }

    /**
     * @param ColumnSave $subject
     * @param Column[] $savedColumns
     *
     * @return Column[]
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterSaveReportColumns(
        ColumnSave $subject,
        array $savedColumns
    ): array {
        foreach ($savedColumns as $column) {
            /** @var ReportVirtualColumn $virtualColumn */
            $virtualColumn = $column->getExtensionAttributes()->getVirtualColumn();

            if ($virtualColumn) {
                if ($virtualColumn->getParentId() !== $column->getId()) {
                    $virtualColumn->setId(null);
                    $virtualColumn->setParentId($column->getId());
                }
                $this->resource->save($virtualColumn);
            }
        }

        return $savedColumns;
    }
}
