<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Plugin\ReportBuilder\Model\Report\ColumnProvider;

use Amasty\ReportBuilder\Model\Report\ColumnProvider;
use Amasty\ReportBuilder\Model\ResourceModel\Report\Column\Collection as ColumnCollection;
use Amasty\ReportBuilderVirtual\Model\ResourceModel\VirtualColumn\CollectionFactory;
use Amasty\ReportBuilderVirtual\Model\ResourceModel\VirtualColumn\Collection as VirtualColumnCollection;

class CollectionAddExtensionAttributes
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    public function __construct(CollectionFactory $collectionFactory)
    {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * Add virtual column data to report column as extension attribute.
     *
     * @param ColumnProvider $subject
     * @param ColumnCollection $columnsCollection
     *
     * @return ColumnCollection
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetCollection(ColumnProvider $subject, ColumnCollection $columnsCollection): ColumnCollection
    {
        $parentIds = $columnsCollection->getIds();

        /** @var VirtualColumnCollection $collection */
        $collection = $this->collectionFactory->create();
        $collection->addParentFilter($parentIds);
        foreach ($collection->getItems() as $virtualColumn) {
            $extensionAttributes = $columnsCollection->getItemById($virtualColumn->getParentId())
                ->getExtensionAttributes();
            $extensionAttributes->setVirtualColumn($virtualColumn);
        }

        return $columnsCollection;
    }
}
