<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Plugin\ReportBuilder\Model\Chart\AxisFactory;

use Amasty\ReportBuilder\Model\Chart\AxisFactory;
use Amasty\ReportBuilder\Model\Chart\AxisInterface;
use Amasty\ReportBuilder\Model\EntityScheme\Column\DataType;
use Amasty\ReportBuilder\Model\Report\ColumnProvider;
use Amasty\ReportBuilderVirtual\Api\Data\ReportVirtualColumnInterface;
use Magento\Framework\ObjectManagerInterface;

class ResolveVirtualColumn
{
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * @var ColumnProvider
     */
    private $columnProvider;

    public function __construct(ObjectManagerInterface $objectManager, ColumnProvider $columnProvider)
    {
        $this->objectManager = $objectManager;
        $this->columnProvider = $columnProvider;
    }

    /**
     * Create axis with data from virtual column.
     *
     * @see AxisFactory::create
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function aroundCreate(
        AxisFactory $subject,
        callable $proceed,
        int $reportId,
        string $columnId
    ): ?AxisInterface {
        $reportColumns = $this->columnProvider->getColumnsByReportId($reportId);
        $reportColumn = $reportColumns[$columnId] ?? null;
        if ($reportColumn === null
            || $reportColumn->getExtensionAttributes()->getVirtualColumn() === null
        ) {
            return $proceed($reportId, $columnId);
        }

        return $this->objectManager->create(AxisInterface::class, [
            AxisInterface::ALIAS_KEY => $columnId,
            AxisInterface::TYPE_KEY => $this->getAxisType($reportColumn->getExtensionAttributes()->getVirtualColumn())
        ]);
    }

    private function getAxisType(ReportVirtualColumnInterface $reportVirtualColumn): string
    {
        if ($reportVirtualColumn->getDataType() === 'arithmetic') {
            return DataType::DECIMAL;
        } else {
            return DataType::VARCHAR;
        }
    }
}
