<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\SelectResolver\SelectColumn;

use Amasty\ReportBuilder\Api\Data\SelectColumnInterface;

class SelectVirtualColumn extends \Amasty\ReportBuilder\Model\SelectResolver\SelectColumn\SelectColumnAbstract
{
    public const TYPE_VIRTUAL = 'virtual';

    /**
     * Select column array key
     */
    public const RELATED_COLUMNS = 'related_columns';

    public function getType(): string
    {
        return self::TYPE_VIRTUAL;
    }

    /**
     * @return SelectColumnInterface[]|null
     */
    public function getRelatedColumns(): ?array
    {
        return $this->_get(self::RELATED_COLUMNS);
    }

    /**
     * @param SelectColumnInterface[] $relatedColumns
     */
    public function setRelatedColumns(array $relatedColumns): void
    {
        $this->setData(self::RELATED_COLUMNS, $relatedColumns);
    }
}
