<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\SelectResolver\ColumnBuilder;

use Amasty\ReportBuilder\Api\Data\SelectColumnInterface;
use Amasty\ReportBuilder\Model\ResourceModel\Report\Data\Select;
use Amasty\ReportBuilder\Model\SelectResolver\ColumnBuilder;
use Amasty\ReportBuilder\Model\SelectResolver\ColumnBuilder\BuilderInterface;
use Amasty\ReportBuilderVirtual\Model\SelectResolver\SelectColumn\SelectVirtualColumn;
use Magento\Framework\DB\Select as DbSelect;
use Magento\Framework\DB\Sql\ExpressionFactory;

class VirtualColumn implements BuilderInterface
{
    /**
     * @var ColumnBuilder
     */
    private $columnBuilder;

    /**
     * @var ExpressionFactory
     */
    private $expressionFactory;

    public function __construct(
        ColumnBuilder $columnBuilder,
        ExpressionFactory $expressionFactory
    ) {
        $this->columnBuilder = $columnBuilder;
        $this->expressionFactory = $expressionFactory;
    }

    /**
     * Process all child columns of context
     *
     * @param Select $select
     * @param SelectVirtualColumn $selectColumn
     */
    public function build(Select $select, SelectColumnInterface $selectColumn): void
    {
        $columns = $select->getPart(DbSelect::COLUMNS);
        // Add column to subselects and column relation
        $this->columnBuilder->buildSelectColumn($select, $selectColumn->getRelatedColumns());
        $select->setPart(DbSelect::COLUMNS, $columns);

        $expression = $this->expressionFactory->create(['expression' => $selectColumn->getExpression()]);
        $select->columns([$selectColumn->getAlias() => $expression]);
    }
}
