<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\ResourceModel\VirtualColumn;

use Amasty\ReportBuilderVirtual\Api\Data\ReportVirtualColumnInterface;
use Amasty\ReportBuilderVirtual\Model\ResourceModel\ReportVirtualColumn;
use Amasty\ReportBuilderVirtual\Model\ReportVirtualColumn as DataModel;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

/**
 * @method DataModel[] getItems()
 */
class Collection extends AbstractCollection
{
    /**
     * @var string
     */
    protected $_eventPrefix = 'amasty_report_builder_column_virtual_collection';

    protected function _construct()
    {
        $this->_init(DataModel::class, ReportVirtualColumn::class);
    }

    /**
     * Serializable fields load fix
     *
     * @return Collection
     */
    protected function _afterLoad(): self
    {
        parent::_afterLoad();

        foreach ($this->getItems() as $item) {
            $this->getResource()->unserializeFields($item);
            $item->setDataChanges(false);
        }

        return $this;
    }

    /**
     * @param int[] $parentIds
     */
    public function addParentFilter(array $parentIds): void
    {
        $this->addFieldToFilter(ReportVirtualColumnInterface::PARENT_ID, ['in' => $parentIds]);
    }
}
