<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\ResourceModel;

use Amasty\ReportBuilderVirtual\Api\Data\ReportVirtualColumnInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class ReportVirtualColumn extends AbstractDb
{
    public const MAIN_TABLE = 'amasty_report_builder_column_virtual';

    /**
     * @var string
     */
    protected $_eventPrefix = 'amasty_report_builder_column_virtual_resource_model';

    protected function _construct()
    {
        $this->_serializableFields[ReportVirtualColumnInterface::CONTEXT] = [[], []];
        $this->_init(self::MAIN_TABLE, ReportVirtualColumnInterface::ID);
        $this->_useIsObjectNew = true;
    }
}
