<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model;

use Amasty\ReportBuilderVirtual\Api\Data\ReportVirtualColumnInterface;
use Magento\Framework\Model\AbstractModel;

class ReportVirtualColumn extends AbstractModel implements ReportVirtualColumnInterface
{
    /**
     * @var string
     */
    protected $_eventPrefix = 'amasty_report_builder_column_virtual_model';

    protected function _construct()
    {
        $this->_init(ResourceModel\ReportVirtualColumn::class);
    }

    public function getId(): ?int
    {
        return $this->getDataByKey(self::ID) === null ? null
            : (int) $this->getDataByKey(self::ID);
    }

    public function setId($id): void
    {
        $this->setData(self::ID, (int)$id);
    }

    public function getParentId(): ?int
    {
        return $this->getDataByKey(self::PARENT_ID) === null ? null
            : (int) $this->getDataByKey(self::PARENT_ID);
    }

    public function setParentId(?int $parentId): void
    {
        $this->setData(self::PARENT_ID, $parentId);
    }

    public function getContext(): array
    {
        return (array)$this->getDataByKey(self::CONTEXT);
    }

    public function setContext(array $context): void
    {
        $this->setData(self::CONTEXT, $context);
    }

    public function getDataType(): ?string
    {
        return $this->getDataByKey(self::DATA_TYPE);
    }

    public function setDataType(?string $dataType): void
    {
        $this->setData(self::DATA_TYPE, $dataType);
    }
}
