<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Operator\Utility;

/**
 * Preprocessor of string expressions
 */
class StringPreprocessing
{
    /**
     * Wrap expression for avoid null result.
     *
     * Any null part of expression will return null after execution.
     *   e.g."CONCAT('test', null)" going to express null result.
     * DB adapter is not used because of optimization.
     *
     * @param string|int $expression
     *
     * @return string
     */
    public function wrapNull($expression): string
    {
        return sprintf('COALESCE(%s, \'\')', $expression);
    }
}
