<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Operator\Utility;

/**
 * Preprocessor of numeric expressions
 */
class NumericPreprocessing
{
    /**
     * Preprocess arithmetical expression.
     *
     * Any null part of expression will return null after execution.
     *   e.g. '1+null' same as 'ABS(null)' going to express null result.
     * DB adapter is not used because of optimization.
     *
     * @param string|int $expression
     *
     * @return string
     */
    public function numericExpression($expression): string
    {
        return sprintf('IFNULL(%s, 0)', $expression);
    }
}
