<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Operator\Unary;

use Amasty\ReportBuilder\Model\EntityScheme\Column\DataType;
use Amasty\ReportBuilderVirtual\Model\Operator\Utility\NumericPreprocessing;

class Absolute implements UnaryInterface
{
    public const IDENTITY = 'abs';

    /**
     * @var NumericPreprocessing
     */
    private $numericPreprocessing;

    public function __construct(NumericPreprocessing $numericPreprocessing)
    {
        $this->numericPreprocessing = $numericPreprocessing;
    }

    public function getIdentity(): string
    {
        return self::IDENTITY;
    }

    public function getApplicableTypes(): array
    {
        return [DataType::INTEGER, DataType::DECIMAL];
    }

    /**
     * @param float|int|string $expression
     * @param null $dependExpression
     *
     * @return string
     * @SuppressWarnings(PHPMD.UnusedFormalParameter) unary operator works only with one expression
     */
    public function buildExpression($expression, $dependExpression = null): string
    {
        return sprintf('ABS(%s)', $this->numericPreprocessing->numericExpression($expression));
    }
}
