<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Operator;

class OperatorProcessor
{
    /**
     * @var OperatorRepository
     */
    private $operatorRepository;

    public function __construct(OperatorRepository $operatorRepository)
    {
        $this->operatorRepository = $operatorRepository;
    }

    /**
     * Covered in \Amasty\ReportBuilderVirtual\Test\Integration\Model\Operator\OperatorProcessorTest::buildExpression
     *
     * @param string $operatorIdentity
     * @param string|int|float $expression
     * @param null|string|int|float $dependExpression
     *
     * @return string
     */
    public function buildExpression(string $operatorIdentity, $expression, $dependExpression = null): string
    {
        return $this->operatorRepository->get($operatorIdentity)->buildExpression($expression, $dependExpression);
    }
}
