<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Operator;

interface OperatorInterface
{
    /**
     * Operator string ID
     *
     * @return string
     */
    public function getIdentity(): string;

    /**
     * @return string[]
     */
    public function getApplicableTypes(): array;

    /**
     * @param string|int|float $expression
     * @param null|string|int|float $dependExpression
     *
     * @return string
     */
    public function buildExpression($expression, $dependExpression = null): string;
}
