<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Operator;

use Amasty\ReportBuilderVirtual\Model\Operator\Binary\BinaryInterface;
use Amasty\ReportBuilderVirtual\Model\Operator\Unary\UnaryInterface;

class OperatorDataProvider
{
    /**
     * @var OperatorRepository
     */
    private $operatorRepository;

    /**
     * @var Category\CategoryRepository
     */
    private $categoryRepository;

    public function __construct(OperatorRepository $operatorRepository, Category\CategoryRepository $categoryRepository)
    {
        $this->operatorRepository = $operatorRepository;
        $this->categoryRepository = $categoryRepository;
    }

    public function getOperatorsConfigs(): array
    {
        $data = [];
        foreach ($this->operatorRepository->getList() as $operator) {
            $identity = $operator->getIdentity();
            $data[$identity] = $this->operatorToArray($operator);
        }

        return $data;
    }

    public function operatorToArray(OperatorInterface $operator): array
    {
        return [
            'type' => $this->getOperatorType($operator), // operator type
            'category' => $this->getOperatorCategoryID($operator), // operator category
            'identity' => $operator->getIdentity(), // operator identification
        ];
    }

    public function getOperatorType(OperatorInterface $operator): string
    {
        if ($operator instanceof BinaryInterface) {
            return BinaryInterface::TYPE;
        }

        return UnaryInterface::TYPE;
    }

    public function getOperatorCategoryID(OperatorInterface $operator): string
    {
        foreach ($this->categoryRepository->getList() as $categoryItem) {
            if ($categoryItem->getApplicableDataTypes() == $operator->getApplicableTypes()) {
                return $categoryItem->getIdentity();
            }
        }

        return '';
    }
}
