<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Operator\Category;

class CategoryRepository
{
    /**
     * @var CategoryItem[]
     */
    private $categories;

    /**
     * @param CategoryItem[] $categories
     */
    public function __construct(array $categories)
    {
        $this->categories = $categories;
    }

    public function get(string $identity): CategoryItem
    {
        return $this->categories[$identity];
    }

    /**
     * @return CategoryItem[]
     */
    public function getList(): array
    {
        return $this->categories;
    }
}
