<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Operator\Category;

class CategoryItem
{
    /**
     * @var string
     */
    private $identity;

    /**
     * @var array
     */
    private $applicableDataTypes;

    /**
     * @var string
     */
    private $label;

    public function __construct(string $identity, array $applicableDataTypes, string $label)
    {
        $this->identity = $identity;
        $this->applicableDataTypes = $applicableDataTypes;
        $this->label = $label;
    }

    /**
     * @return string
     */
    public function getIdentity(): string
    {
        return $this->identity;
    }

    /**
     * Category can be applied to returned data types.
     * Category contains operators with such data types.
     * Operator should have same data types to be in category.
     *
     * @return array
     */
    public function getApplicableDataTypes(): array
    {
        return $this->applicableDataTypes;
    }

    /**
     * @return string
     */
    public function getLabel(): string
    {
        return $this->label;
    }
}
