<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Operator\Category;

/**
 * Present operator Categories as array
 */
class CategoryDataProvider
{
    /**
     * @var CategoryRepository
     */
    private $categoryRepository;

    public function __construct(CategoryRepository $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
    }

    /**
     * UI component categories data
     *
     * @return array
     */
    public function getData(): array
    {
        $result = [];
        foreach ($this->categoryRepository->getList() as $category) {
            $identity = $category->getIdentity();
            $result[$identity] = [
                'identify' => $identity,
                'label' => $category->getLabel(),
                'data-types' => $category->getApplicableDataTypes()
            ];
        }

        return $result;
    }
}
