<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Operator\Binary;

use Amasty\ReportBuilder\Model\EntityScheme\Column\DataType;

class Percentage implements BinaryInterface
{
    public const IDENTITY = 'percent';

    public function getIdentity(): string
    {
        return self::IDENTITY;
    }

    public function getApplicableTypes(): array
    {
        return [DataType::INTEGER, DataType::DECIMAL];
    }

    public function buildExpression($expression, $dependExpression = null): string
    {
        return sprintf('%s / 100 * %s', $expression, $dependExpression);
    }
}
