<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Operator\Binary;

use Amasty\ReportBuilder\Model\EntityScheme\Column\DataType;
use Amasty\ReportBuilderVirtual\Model\Operator\Utility\NumericPreprocessing;

class Multiplication implements BinaryInterface
{
    public const IDENTITY = 'multiply';

    /**
     * @var NumericPreprocessing
     */
    private $numericPreprocessing;

    public function __construct(NumericPreprocessing $numericPreprocessing)
    {
        $this->numericPreprocessing = $numericPreprocessing;
    }

    public function getIdentity(): string
    {
        return self::IDENTITY;
    }

    public function getApplicableTypes(): array
    {
        return [DataType::INTEGER, DataType::DECIMAL];
    }

    public function buildExpression($expression, $dependExpression = null): string
    {
        return sprintf(
            '%s * %s',
            $this->numericPreprocessing->numericExpression($expression),
            $this->numericPreprocessing->numericExpression($dependExpression)
        );
    }
}
