<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Operator\Binary;

use Amasty\ReportBuilder\Model\EntityScheme\Column\DataType;
use Amasty\ReportBuilderVirtual\Model\Operator\Utility\StringPreprocessing;

class Concatenation implements BinaryInterface
{
    public const IDENTITY = 'append';

    /**
     * @var StringPreprocessing
     */
    private $stringPreprocessing;

    public function __construct(StringPreprocessing $stringPreprocessing)
    {
        $this->stringPreprocessing = $stringPreprocessing;
    }

    public function getIdentity(): string
    {
        return self::IDENTITY;
    }

    public function getApplicableTypes(): array
    {
        return [DataType::INTEGER, DataType::DECIMAL, DataType::VARCHAR, DataType::DATE, DataType::DATETIME];
    }

    public function buildExpression($expression, $dependExpression = null): string
    {
        return sprintf(
            'CONCAT(%s, \' \', %s)',
            $this->stringPreprocessing->wrapNull($expression),
            $this->stringPreprocessing->wrapNull($dependExpression)
        );
    }
}
