<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\ContextProcessor;

use Amasty\ReportBuilderVirtual\Api\Data\ReportVirtualColumnInterface;
use Amasty\ReportBuilderVirtual\Model\Context\ContextListProvider;
use Amasty\ReportBuilderVirtual\Model\SelectResolver\SelectColumn\SelectVirtualColumn;

class VirtualExpressionProcessor
{
    /**
     * @var ContextListProvider
     */
    private $contextProvider;

    /**
     * @var ExpressionElementOperatorProcessor
     */
    private $operatorProcessor;

    /**
     * @var ExpressionElementsAdapter
     */
    private $elementsAdapter;

    public function __construct(
        ContextListProvider $contextProvider,
        ExpressionElementOperatorProcessor $operatorProcessor,
        ExpressionElementsAdapter $elementsAdapter
    ) {
        $this->contextProvider = $contextProvider;
        $this->operatorProcessor = $operatorProcessor;
        $this->elementsAdapter = $elementsAdapter;
    }

    public function execute(ReportVirtualColumnInterface $reportColumn, SelectVirtualColumn $selectColumn): string
    {
        $context = $this->contextProvider->getByColumn($reportColumn);
        $expressionElements = $this->elementsAdapter->execute($context->getElements(), $selectColumn);

        return $this->operatorProcessor->buildExpression($expressionElements);
    }
}
