<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\ContextProcessor;

use Amasty\ReportBuilderVirtual\Model\Context\Element\ElementInterface;
use Amasty\ReportBuilderVirtual\Model\Operator\OperatorProcessor;
use Amasty\ReportBuilderVirtual\Model\SelectResolver\SelectColumn\SelectVirtualColumn;

class ExpressionElementsAdapter
{
    /**
     * @var ExpressionElementFactory
     */
    private $expressionElementFactory;

    /**
     * @var OperatorProcessor
     */
    private $operatorProcessor;

    /**
     * @var Element\ElementProcessorInterface[]
     */
    private $elementProcessors;

    /**
     * @param ExpressionElementFactory $expressionElementFactory
     * @param Element\ElementProcessorInterface[] $elementProcessors
     */
    public function __construct(
        ExpressionElementFactory $expressionElementFactory,
        OperatorProcessor $operatorProcessor,
        array $elementProcessors = []
    ) {
        $this->expressionElementFactory = $expressionElementFactory;
        $this->operatorProcessor = $operatorProcessor;
        $this->elementProcessors = $elementProcessors;
    }

    /**
     * @param ElementInterface[] $elementItems
     * @param SelectVirtualColumn $selectColumn
     *
     * @return ExpressionElement[]
     */
    public function execute(array $elementItems, SelectVirtualColumn $selectColumn): array
    {
        $expressionElements = [];
        foreach ($elementItems as $element) {

            $expressionProcessor = $this->elementProcessors[$element->getCategory()];
            $expression = $expressionProcessor->execute($element, $selectColumn, $this);

            if ($element->getModifier() !== null) {
                foreach ($element->getModifier() as $operatorId) {
                    $expression = $this->operatorProcessor->buildExpression($operatorId, $expression);
                }
            }

            $expressionElements[] = $this->expressionElementFactory->create(
                [
                    'element' => $element,
                    'expression' => $expression,
                    'id' => $element->getId()
                ]
            );
        }

        return $expressionElements;
    }
}
