<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\ContextProcessor;

use Amasty\ReportBuilderVirtual\Model\Operator\OperatorProcessor;

class ExpressionElementOperatorProcessor
{
    /**
     * @var OperatorProcessor
     */
    private $operatorProcessor;

    public function __construct(OperatorProcessor $operatorProcessor)
    {
        $this->operatorProcessor = $operatorProcessor;
    }

    /**
     * @param ExpressionElement[] $elementItems
     *
     * @return string
     */
    public function buildExpression(array $elementItems): string
    {
        if (empty($elementItems)) {
            return '';
        }

        $leftElement = current($elementItems);
        $resultExpression = $leftElement->getExpression();

        foreach ($elementItems as $leftElement) {
            $operator = $leftElement->getElement()->getOperation();
            if (!$operator) {
                break;
            }
            $rightElement = next($elementItems);
            if ($rightElement) {
                $resultExpression = $this->operatorBuildExpression($operator, $resultExpression, $rightElement);
            }
        }

        return $resultExpression;
    }

    /**
     * @param string $operator
     * @param $resultExpression
     * @param $rightElement
     *
     * @return string
     */
    private function operatorBuildExpression(string $operator, $resultExpression, $rightElement): string
    {
        return $this->operatorProcessor->buildExpression(
            $operator,
            $resultExpression,
            $rightElement->getExpression()
        );
    }
}
