<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\ContextProcessor;

use Amasty\ReportBuilderVirtual\Model\Context\Element\ElementInterface;

class ExpressionElement
{
    /**
     * @var ElementInterface|null
     */
    private $element;

    /**
     * @var string|null
     */
    private $expression;

    /**
     * @var int|null
     */
    private $id;

    public function __construct(ElementInterface $element = null, string $expression = null, int $id = null)
    {
        $this->element = $element;
        $this->expression = $expression;
        $this->id = $id;
    }

    /**
     * @return ElementInterface
     */
    public function getElement(): ElementInterface
    {
        return $this->element;
    }

    /**
     * @return string|null
     */
    public function getExpression(): ?string
    {
        return $this->expression;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }
}
