<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\ContextProcessor\Element;

use Amasty\ReportBuilderVirtual\Model\Context\Element\ElementInterface;
use Amasty\ReportBuilderVirtual\Model\Context\Element\Input;
use Amasty\ReportBuilderVirtual\Model\ContextProcessor\ExpressionElementsAdapter;
use Amasty\ReportBuilderVirtual\Model\SelectResolver\SelectColumn\SelectVirtualColumn;
use Magento\Framework\App\ResourceConnection;

class InputProcessor implements ElementProcessorInterface
{
    /**
     * @var \Magento\Framework\DB\Adapter\AdapterInterface
     */
    private $databaseAdapter;

    public function __construct(ResourceConnection $resourceConnection)
    {
        $this->databaseAdapter = $resourceConnection->getConnection();
    }

    /**
     * @param Input $element
     * @param SelectVirtualColumn $selectColumn
     *
     * @return string
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function execute(
        ElementInterface $element,
        SelectVirtualColumn $selectColumn,
        ExpressionElementsAdapter $adapter
    ): string {
        return (string) $this->databaseAdapter->quote($element->getValue());
    }
}
