<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\ContextProcessor\Element;

use Amasty\ReportBuilder\Model\SelectResolver\SelectColumn\ColumnExpression;
use Amasty\ReportBuilder\Model\SelectResolver\SelectColumn\ColumnExpressionResolver;
use Amasty\ReportBuilderVirtual\Model\Context\Element\Column;
use Amasty\ReportBuilderVirtual\Model\Context\Element\ElementInterface;
use Amasty\ReportBuilderVirtual\Model\ContextProcessor\ExpressionElementsAdapter;
use Amasty\ReportBuilderVirtual\Model\SelectResolver\SelectColumn\SelectVirtualColumn;
use Magento\Framework\Exception\NotFoundException;

class ColumnProcessor implements ElementProcessorInterface
{
    /**
     * @var ColumnExpression
     */
    private $columnExpression;

    public function __construct(ColumnExpression $columnExpression)
    {
        $this->columnExpression = $columnExpression;
    }

    /**
     * @param Column $element
     * @param SelectVirtualColumn $selectColumn
     *
     * @return string
     * @throws NotFoundException
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function execute(
        ElementInterface $element,
        SelectVirtualColumn $selectColumn,
        ExpressionElementsAdapter $adapter
    ): string {
        $columnId = $element->getColumnId();
        foreach ($selectColumn->getRelatedColumns() as $childSelectColumn) {
            if ($columnId === $childSelectColumn->getColumnId()) {
                return $this->columnExpression->collectExpression($childSelectColumn);
            }
        }

        throw new NotFoundException(
            __('Cant find child column of virtual column. Column ID = "%column_id"', ['column_id' => $columnId])
        );
    }
}
