<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\ContextProcessor\Element;

use Amasty\ReportBuilderVirtual\Model\Context\Element\Brackets;
use Amasty\ReportBuilderVirtual\Model\Context\Element\ElementInterface;
use Amasty\ReportBuilderVirtual\Model\ContextProcessor\ExpressionElementOperatorProcessor;
use Amasty\ReportBuilderVirtual\Model\ContextProcessor\ExpressionElementsAdapter;
use Amasty\ReportBuilderVirtual\Model\SelectResolver\SelectColumn\SelectVirtualColumn;

class BracketsProcessor implements ElementProcessorInterface
{
    /**
     * @var ExpressionElementOperatorProcessor
     */
    private $operatorProcessor;

    /**
     * @param ExpressionElementOperatorProcessor $operatorProcessor
     */
    public function __construct(
        ExpressionElementOperatorProcessor $operatorProcessor
    ) {
        $this->operatorProcessor = $operatorProcessor;
    }

    /**
     * @param Brackets $element
     * @param SelectVirtualColumn $selectColumn
     * @param ExpressionElementsAdapter $adapter
     *
     * @return string
     */
    public function execute(
        ElementInterface $element,
        SelectVirtualColumn $selectColumn,
        ExpressionElementsAdapter $adapter
    ): string {
        $childExpressions = $adapter->execute($element->getElements(), $selectColumn);
        $expression = $this->operatorProcessor->buildExpression($childExpressions);

        return sprintf('(%s)', $expression);
    }
}
