<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Context;

use Amasty\ReportBuilderVirtual\Model\Context\Element\Brackets;
use Amasty\ReportBuilderVirtual\Model\Context\Element\BracketsFactory;
use Amasty\ReportBuilderVirtual\Model\Context\Element\Column;
use Amasty\ReportBuilderVirtual\Model\Context\Element\ColumnFactory;
use Amasty\ReportBuilderVirtual\Model\Context\Element\ElementInterface;
use Amasty\ReportBuilderVirtual\Model\Context\Element\Input;
use Amasty\ReportBuilderVirtual\Model\Context\Element\InputFactory;
use LogicException;

class ElementFactory
{
    /**
     * @var Element\ColumnFactory
     */
    private $columnFactory;

    /**
     * @var BracketsFactory
     */
    private $bracketsFactory;

    /**
     * @var InputFactory
     */
    private $inputFactory;

    public function __construct(
        ColumnFactory $columnFactory,
        BracketsFactory $bracketsFactory,
        InputFactory $inputFactory
    ) {
        $this->columnFactory = $columnFactory;
        $this->bracketsFactory = $bracketsFactory;
        $this->inputFactory = $inputFactory;
    }

    /**
     * @param string $type
     * @param array $data
     *
     * @return Column|Input|Brackets
     * @throws LogicException
     */
    public function create(string $type, array $data): ElementInterface
    {
        switch ($type) {
            case Column::CATEGORY:
                return $this->columnFactory->create(['data' => $data]);
            case Brackets::CATEGORY:
                return $this->bracketsFactory->create(['data' => $data]);
            case Input::CATEGORY:
                return $this->inputFactory->create(['data' => $data]);
        }

        throw new LogicException(
            (string) __('Element type "%type" is unexpected, can\'t create data model.', ['type' => $type])
        );
    }
}
