<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Context\Element;

interface ElementInterface
{
    /**
     * String constants for property names
     */
    public const CATEGORY_KEY = 'category';

    public const TYPE_KEY = 'type';

    public const ID_KEY = 'id';

    public const ORDER_KEY = 'order';

    public const MODIFIER_KEY = 'modifier';

    public const OPERATION_KEY = 'operation';

    /**
     * Element type.
     *
     * @return string
     */
    public function getCategory(): string;

    /**
     * Getter for Type.
     *
     * @return string|null
     */
    public function getType(): ?string;

    /**
     * Setter for Type.
     *
     * @param string|null $type
     *
     * @return void
     */
    public function setType(?string $type): void;

    /**
     * Getter for Id.
     *
     * @return int|null
     */
    public function getId(): ?int;

    /**
     * Setter for Id.
     *
     * @param int|null $id
     *
     * @return void
     */
    public function setId(?int $id): void;

    /**
     * Getter for Order.
     *
     * @return int|null
     */
    public function getOrder(): ?int;

    /**
     * Setter for Order.
     *
     * @param int|null $order
     *
     * @return void
     */
    public function setOrder(?int $order): void;

    /**
     * Getter for Modifier.
     *
     * @return string[]|null
     */
    public function getModifier(): ?array;

    /**
     * Setter for Modifier.
     *
     * @param string[] $modifier
     *
     * @return void
     */
    public function setModifier(array $modifier): void;

    /**
     * Getter for Operation.
     *
     * @return string|null
     */
    public function getOperation(): ?string;

    /**
     * Setter for Operation.
     *
     * @param string|null $operation
     *
     * @return void
     */
    public function setOperation(?string $operation): void;
}
