<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Context\Element;

/**
 * Virtual Column child data as Emulated Report Column.
 * Virtual Column child is a part of virtual column context.
 * TODO refactor mapping CAT-16241
 */
class Column extends \Amasty\ReportBuilder\Model\Report\Column implements ElementInterface
{
    public const CATEGORY = 'column';

    /**
     * Restrict save for dummy object
     * @return bool
     */
    public function isSaveAllowed(): bool
    {
        return false;
    }

    public function getCategory(): string
    {
        return static::CATEGORY;
    }

    public function getType(): ?string
    {
        return $this->getDataByKey(self::TYPE_KEY);
    }

    public function setType(?string $type): void
    {
        $this->setData(self::TYPE_KEY, $type);
    }

    public function getOrder(): ?int
    {
        return $this->getDataByKey(self::ORDER_KEY) === null ? null
            : (int) $this->getDataByKey(self::ORDER_KEY);
    }

    public function setOrder(?int $order): void
    {
        $this->setData(self::ORDER_KEY, $order);
    }

    public function getModifier(): ?array
    {
        return $this->getDataByKey(self::MODIFIER_KEY);
    }

    public function setModifier(array $modifier): void
    {
        $this->setData(self::MODIFIER_KEY, $modifier);
    }

    public function getOperation(): ?string
    {
        return $this->getDataByKey(self::OPERATION_KEY);
    }

    public function setOperation(?string $operation): void
    {
        $this->setData(self::OPERATION_KEY, $operation);
    }
}
