<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Context\Element;

use Magento\Framework\DataObject;

class Brackets extends DataObject implements ElementInterface
{
    public const CATEGORY = 'brackets';
    public const ELEMENTS_KEY = 'elements';

    public function getCategory(): string
    {
        return static::CATEGORY;
    }

    public function getElements(): array
    {
        return (array)$this->getDataByKey(self::ELEMENTS_KEY);
    }

    public function setElements(array $elements): void
    {
        $this->setData(self::ELEMENTS_KEY, $elements);
    }

    public function getType(): ?string
    {
        return $this->getDataByKey(self::TYPE_KEY);
    }

    public function setType(?string $type): void
    {
        $this->setData(self::TYPE_KEY, $type);
    }

    public function getId(): ?int
    {
        return $this->getDataByKey(self::ID_KEY) === null ? null
            : (int) $this->getDataByKey(self::ID_KEY);
    }

    public function setId(?int $id): void
    {
        $this->setData(self::ID_KEY, $id);
    }

    public function getOrder(): ?int
    {
        return $this->getDataByKey(self::ORDER_KEY) === null ? null
            : (int) $this->getDataByKey(self::ORDER_KEY);
    }

    public function setOrder(?int $order): void
    {
        $this->setData(self::ORDER_KEY, $order);
    }

    public function getModifier(): ?array
    {
        return $this->getDataByKey(self::MODIFIER_KEY);
    }

    public function setModifier(array $modifier): void
    {
        $this->setData(self::MODIFIER_KEY, $modifier);
    }

    public function getOperation(): ?string
    {
        return $this->getDataByKey(self::OPERATION_KEY);
    }

    public function setOperation(?string $operation): void
    {
        $this->setData(self::OPERATION_KEY, $operation);
    }
}
