<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Context;

use Amasty\ReportBuilderVirtual\Api\Data\ReportVirtualColumnInterface;

class ContextListProvider
{
    /**
     * @var array
     */
    private $listRegistry;

    /**
     * @var ContextListBuilder
     */
    private $contextListBuilder;

    public function __construct(ContextListBuilder $contextListBuilder)
    {
        $this->contextListBuilder = $contextListBuilder;
    }

    /**
     * @param ReportVirtualColumnInterface $column
     *
     * @return ContextList
     */
    public function getByColumn(ReportVirtualColumnInterface $column): ContextList
    {
        $id = $column->getId() ?: spl_object_hash($column);
        if (!isset($this->listRegistry[$id])) {
            $this->listRegistry[$id] = $this->contextListBuilder->build($column->getContext());
        }

        return $this->listRegistry[$id];
    }
}
