<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Context;

class ContextList
{
    /**
     * Raw context
     *
     * @var array
     */
    private $context;

    /**
     * @var \Amasty\ReportBuilderVirtual\Model\Context\Element\ElementInterface[]
     */
    private $elements;

    /**
     * @var Element\Column[]
     */
    private $columns;

    /**
     * @param array $context
     * @param Element\ElementInterface[] $elements
     * @param Element\Column[] $columns
     */
    public function __construct(array $context = [], array $elements = [], array $columns = [])
    {
        $this->context = $context;
        $this->elements = $elements;
        $this->columns = $columns;
    }

    /**
     * @return Element\ElementInterface[]
     */
    public function getElements(): array
    {
        return $this->elements;
    }

    /**
     * All used column.
     *
     * @return Element\Column[]
     */
    public function getColumns(): array
    {
        return $this->columns;
    }

    /**
     * @return array \Amasty\ReportBuilderVirtual\Api\Data\ReportVirtualColumnInterface::getContext
     */
    public function getContext(): array
    {
        return $this->context;
    }
}
