<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Model\Backend\Report\DataCollector\Entity;

use Amasty\ReportBuilder\Api\Data\ReportColumnInterface;
use Amasty\ReportBuilder\Api\Data\ReportInterface;
use Amasty\ReportBuilder\Model\Backend\Report\DataCollector\Entity\ColumnEntity;
use Amasty\ReportBuilder\Model\Backend\Report\DataCollector\Entity\EntityCollectorInterface;
use Amasty\ReportBuilderVirtual\Model\Context\ContextListProvider;

/**
 * Add all dependent entities of child columns used in virtual column
 */
class VirtualColumnsEntity implements EntityCollectorInterface
{
    /**
     * @var ColumnEntity
     */
    private $columnEntity;

    /**
     * @var ContextListProvider
     */
    private $contextListProvider;

    public function __construct(ColumnEntity $columnEntity, ContextListProvider $contextListProvider)
    {
        $this->columnEntity = $columnEntity;
        $this->contextListProvider = $contextListProvider;
    }

    /**
     * @param ReportInterface $report
     * @param ReportColumnInterface $reportColumn
     * @param array $relations = [
     *     [
     *          ReportInterface::SCHEME_SOURCE_ENTITY => 'parent_entity_name',
     *          ReportInterface::SCHEME_ENTITY => 'child_entity_name'
     *     ],
     * ]
     */
    public function collect(ReportInterface $report, ReportColumnInterface $reportColumn, array &$relations): void
    {
        $virtualColumn = $reportColumn->getExtensionAttributes()->getVirtualColumn();

        if (!$virtualColumn) {
            return;
        }

        $context = $this->contextListProvider->getByColumn($virtualColumn);
        foreach ($context->getColumns() as $childColumn) {
            $this->columnEntity->collect($report, $childColumn, $relations);
        }
    }
}
