<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

namespace Amasty\ReportBuilderVirtual\Model\Backend\Report\DataCollector\Columns;

use Amasty\ReportBuilderVirtual\Model\Context\Element\Brackets;

/**
 * TODO refactor mapping CAT-16241
 */
class ContextColumn
{
    /**
     * Map column data property to column root
     *
     * @param array $context
     */
    public function prepareColumns(array &$context)
    {
        foreach ($context as &$element) {
            if (!empty($element[Brackets::ELEMENTS_KEY])) {
                $this->prepareColumns($element[Brackets::ELEMENTS_KEY]);
            }

            if (!empty($element['columnData'])) {
                unset(
                    $element['columnData']['modifier'],
                    $element['columnData']['operation'],
                    $element['columnData']['columnData']
                );
                $this->mergeArray($element, $element['columnData']);
                unset($element['columnData']);
            }
        }
    }

    /**
     * @param array $array1
     * @param array $array2
     */
    private function mergeArray(array &$array1, array &$array2)
    {
        foreach ($array2 as $key => $i) {
            $array1[$key] = $i;
        }
    }
}
