<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Virtual Columns (System)
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderVirtual\Api\Data;

/**
 * Additional column data of complex combined column.
 * One-to-one link type.
 */
interface ReportVirtualColumnInterface
{
    /**
     * String constants for property names
     */
    public const ID = 'id';

    /**
     * Unique value
     */
    public const PARENT_ID = 'parent_id';

    /**
     * Stored in JSON.
     * After load converts to array.
     * On save converts to JSON.
     */
    public const CONTEXT = 'context';

    public const DATA_TYPE = 'data_type';

    /**
     * Extension attributes key
     */
    public const EXTENDED_KEY = 'virtual_column';

    /**
     * Getter for Id.
     *
     * @return int|null
     */
    public function getId(): ?int;

    /**
     * Setter for Id.
     *
     * @param int|null $id
     *
     * @return void
     */
    public function setId(?int $id): void;

    /**
     * Getter for ParentId.
     *
     * @return int|null
     */
    public function getParentId(): ?int;

    /**
     * Setter for ParentId.
     *
     * @param int|null $parentId
     *
     * @return void
     */
    public function setParentId(?int $parentId): void;

    /**
     * Getter for Data.
     *
     * @return array [
     *     [
     *         'category' => 'column'|'brackets'|'input', // element type
     *         'type' => 'text'|'decimal'|'varchar'|'int'|'datetime', // element subtype
     *         'column_id' => 'order.entity_id', // column schema id
     *         'id' => 111, // element id
     *         'order' => 0, // element order
     *         'modifier' => 222, // unary operator id
     *         'elements' => [$elementData], // array of elements for brackets
     *         'operation' => []|null // null - without operator | {} - select operator | {operation.id: element.id},
     *     ],
     * ]
     */
    public function getContext(): array;

    /**
     * Setter for Data.
     *
     * @param array $context
     *
     * @return void
     */
    public function setContext(array $context): void;

    /**
     * Getter for DataType.
     *
     * @return string|null
     */
    public function getDataType(): ?string;

    /**
     * Setter for DataType.
     *
     * @param string|null $dataType
     *
     * @return void
     */
    public function setDataType(?string $dataType): void;
}
