<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Estimation for Magento 2
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderEstimation\Model\ResourceModel\Indexer\Estimation;

use Magento\Framework\App\ResourceConnection;
use Magento\Framework\DB\Adapter\AdapterInterface;

class IndexResource
{
    public const MAIN_TABLE = 'amasty_report_builder_sales_estimation';
    public const REPLICA_TABLE = 'amasty_report_builder_sales_estimation_replica';

    public const PRODUCT_ID_COLUMN = 'product_id';
    public const AVG_SALES_COLUMN = 'avg_sales';
    public const STOCK_THRESHOLD_COLUMN = 'stock_threshold';

    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    public function __construct(ResourceConnection $resourceConnection)
    {
        $this->resourceConnection = $resourceConnection;
    }

    public function getConnection(): AdapterInterface
    {
        return $this->resourceConnection->getConnection();
    }

    public function getTableName(string $tableName): string
    {
        return $this->resourceConnection->getTableName($tableName);
    }
}
