<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Estimation for Magento 2
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderEstimation\Model\Indexer\Estimation;

use Amasty\ReportBuilder\Model\Indexer\Stock\IndexerInterface;
use Amasty\ReportBuilderEstimation\Model\ResourceModel\Indexer\Estimation\TableWorker;
use Exception;
use Magento\Framework\DB\Query\Generator as QueryGenerator;
use Magento\Framework\Exception\LocalizedException;
use Psr\Log\LoggerInterface;

/**
 * Model for populate index table amasty_report_builder_sales_estimation.
 * Data used for creating reports in Amasty_ReportBuilder.
 */
class Indexer implements IndexerInterface
{
    /**
     * @var TableWorker
     */
    private $tableWorker;

    /**
     * @var GetIndexSelect
     */
    private $getIndexSelect;

    /**
     * @var QueryGenerator
     */
    private $queryGenerator;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var int
     */
    private $batchCount;

    public function __construct(
        TableWorker $tableWorker,
        GetIndexSelect $getIndexSelect,
        QueryGenerator $queryGenerator,
        LoggerInterface $logger,
        int $batchCount = 10000
    ) {
        $this->tableWorker = $tableWorker;
        $this->getIndexSelect = $getIndexSelect;
        $this->queryGenerator = $queryGenerator;
        $this->logger = $logger;
        $this->batchCount = $batchCount;
    }

    public function execute(): void
    {
        try {
            $this->populateTemporaryTable();

            $this->tableWorker->syncDataFull();
            $this->tableWorker->switchTables();
        } catch (Exception $e) {
            $this->logger->error($e->getMessage());
        }
    }

    /**
     * Populate temp table with stock estimation data.
     */
    private function populateTemporaryTable(): void
    {
        $this->tableWorker->createTemporaryTable();

        $batchQueries = $this->queryGenerator->generate(
            'entity_id',
            $this->getIndexSelect->execute(),
            $this->batchCount
        );

        foreach ($batchQueries as $batchQuery) {
            $this->tableWorker->insertToTemporaryTable($batchQuery);
        }
    }
}
