<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Estimation for Magento 2
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderEstimation\Model\Indexer\Estimation;

use Amasty\ReportBuilderEstimation\Model\ConfigProvider;
use Amasty\ReportBuilderEstimation\Model\ResourceModel\Indexer\Estimation\GetIndexSelect as GetIndexSelectResource;
use LogicException;
use Magento\Framework\DB\Select;

class GetIndexSelect
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var GetIndexSelectResource
     */
    private $getIndexSelectResource;

    public function __construct(ConfigProvider $configProvider, GetIndexSelectResource $getIndexSelectResource)
    {
        $this->configProvider = $configProvider;
        $this->getIndexSelectResource = $getIndexSelectResource;
    }

    /**
     * @throws LogicException
     */
    public function execute(): Select
    {
        $estimationDays = $this->configProvider->getEstimationDays();
        if (!$estimationDays) {
            throw new LogicException('Incorrect estimation days value.');
        }

        return $this->getIndexSelectResource->execute($estimationDays);
    }
}
