<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Report Builder Estimation for Magento 2
*/

declare(strict_types=1);

namespace Amasty\ReportBuilderEstimation\Model;

use Amasty\Base\Model\ConfigProviderAbstract;

class ConfigProvider extends ConfigProviderAbstract
{
    public const ESTIMATION_DAYS_PATH = 'general/estimation_days';

    /**
     * @var string
     */
    protected $pathPrefix = 'amasty_report_builder/';

    public function getEstimationDays(): int
    {
        return (int) $this->getValue(self::ESTIMATION_DAYS_PATH);
    }
}
