define([
    'underscore',
    'amcharts'
], function (_, amcharts) {
    'use strict';

    var model = {
        /**
         * Axis Series initialization
         *
         * @private
         * @returns {void}
         */
        _initSeries: function () {
            if (this.chart.series.length) {
                this.chart.series.removeIndex(0);
            }

            this.series = new window.am4charts.ColumnSeries();
        },

        /**
         * Axis initialization
         *
         * @private
         * @param {String} axis
         * @param {String} type
         * @returns {void}
         */
        _initAxis: function (axis, type) {
            if (this.chart[axis + 'Axes'].length) {
                this.chart[axis + 'Axes'].removeIndex(0);
            }

            switch (type) {
                case 'smallint':
                case 'decimal':
                    this.initTypeValue(axis);
                    break;
                case 'text':
                case 'varchar':
                case 'int':
                    this.initTypeCategory(axis);
                    break;
                default:
                    this.initTypeDate(axis);
            }
        },

        /**
         * Chart rendering
         *
         * @param {Object} response
         * @private
         * @returns {void}
         */
        _renderChart: function (response) {
            this.chart.xAxes.push(this.valueAxisX);
            this.chart.yAxes.push(this.valueAxisY);
            this.chart.series.push(this.series);

            model._applyConfig.call(this, response);
        },

        /**
         * Apply chart config from xml and set additional settings based on chart type
         *
         * @param {Object} response
         * @private
         * @returns {void}
         */
        _applyConfig: function (response) {
            var config = this.chart_types[this.chartType];

            if (_.isUndefined(config)) {
                return;
            }

            this.setChartConfig(config.settings);

            this.series.columns.template.tooltipText = this.getTooltipText('valueX', 'valueY');
            this.valueAxisX.renderer.grid.template.location = 0;
            this.valueAxisX.renderer.minGridDistance = 30;
            this.valueAxisX.renderer.labels.template.wrap = true;
            this.valueAxisX.renderer.labels.template.truncate = true;
            this.valueAxisX.renderer.labels.template.maxWidth = 150;

            this.valueAxisY.renderer.labels.template.wrap = true;
            this.valueAxisY.renderer.labels.template.maxWidth = 280;

            this.setLabelsOffsetX(this.valueAxisX, response.data);
        }
    };

    return {
        /**
         * @public
         * @param {Object} node
         * @returns {void}
         */
        init: function (node) {
            this.chart = window.am4core.create(node, amcharts.XYChart);

            this.initScrollbar();
        },

        /**
         * @public
         * @param {Object} response
         * @returns {void}
         */
        update: function (response) {
            model._initSeries.call(this);
            model._initAxis.call(this, 'x', response.xAxisType);
            model._initAxis.call(this, 'y', response.yAxisType);
            model._renderChart.call(this, response);
        }
    };
});
