define([
    'underscore',
    'amcharts'
], function (_, amcharts) {
    'use strict';

    var model = {
        /**
         * Axis Series initialization
         *
         * @private
         * @returns {void}
         */
        _initSeries: function () {
            if (this.chart.series.length) {
                this.chart.series.removeIndex(0);
            }

            this.series = new window.am4charts.PieSeries();
        },

        /**
         * Chart rendering
         *
         * @private
         * @returns {void}
         */
        _renderChart: function () {
            model._applyConfig.call(this);

            this.chart.series.push(this.series);
        },

        /**
         * Apply chart config from xml and set additional settings based on chart type
         *
         * @private
         * @returns {void}
         */
        _applyConfig: function () {
            var config = this.chart_types[this.chartType];

            if (_.isUndefined(config)) {
                return;
            }

            this.setChartConfig(config.settings);

            // eslint-disable-next-line default-case
            switch (this.chartType) {
                case this.chart_types.simplePie.type:
                    this.series.slices.template.tooltipText = this.getTooltipText('category', 'value.value');
                    break;
                case this.chart_types.semiCirclePie.type:
                    this.series.slices.template.inert = true;
                    this.series.alignLabels = false;
                    this.initLegend();
            }

            this.series.labels.template.maxWidth = 300;
            this.series.labels.template.truncate = true;
        },

        /**
         * Fields initialization
         *
         * @private
         * @param {String} type
         * @param {String} data
         * @returns {void}
         */
        _initFields: function (type, data) {
            this.series.dataFields[type] = data;
        }
    };

    return {
        /**
         * @public
         * @param {Object} node
         * @returns {void}
         */
        init: function (node) {
            this.chart = window.am4core.create(node, amcharts.PieChart);
        },

        /**
         * @public
         * @param {Object} response
         * @returns {void}
         */
        update: function (response) {
            model._initSeries.call(this);
            model._initFields.call(this, 'category', 'valuePIE');
            model._initFields.call(this, 'value', 'valueSLICE');
            model._renderChart.call(this);
        }
    };
});
