define([
    'underscore',
    'amcharts'
], function (_, amcharts) {
    'use strict';

    var model = {
        /**
         * Axis Series initialization
         *
         * @private
         * @returns {void}
         */
        _initSeries: function () {
            if (this.chart.series.length) {
                this.chart.series.removeIndex(0);
            }

            this.series = new window.am4charts.ColumnSeries();
        },

        /**
         * Axis initialization
         *
         * @private
         * @param {String} axis
         * @param {String} type
         * @returns {void}
         */
        _initAxis: function (axis, type) {
            if (this.chart[axis + 'Axes'].length) {
                this.chart[axis + 'Axes'].removeIndex(0);
            }

            switch (type) {
                case 'smallint':
                case 'decimal':
                    this.initTypeValue(axis);
                    break;
                case 'text':
                case 'varchar':
                case 'int':
                    this.initTypeCategory(axis);
                    break;
                default:
                    this.initTypeDate(axis);
            }
        },

        /**
         * Chart rendering
         *
         * @private
         * @returns {void}
         */
        _renderChart: function () {
            this.chart.xAxes.push(this.valueAxisX);
            this.chart.yAxes.push(this.valueAxisY);
            this.chart.series.push(this.series);

            model._applyConfig.call(this);
        },

        /**
         * Apply chart config from xml and set additional settings based on chart type
         *
         * @private
         * @returns {void}
         */
        _applyConfig: function () {
            var config = this.chart_types[this.chartType],
                labelBullet;

            if (_.isUndefined(config)) {
                return;
            }

            this.setChartConfig(config.settings);

            labelBullet = this.series.bullets.push(new amcharts.LabelBullet());

            labelBullet.interactionsEnabled = false;
            labelBullet.dy = 30;
            labelBullet.label.text = '{valueY}';
            labelBullet.label.fill = window.am4core.color('#fff');

            this.valueAxisX.renderer.grid.template.location = 0;
            this.valueAxisX.renderer.cellStartLocation = 0.1;
            this.valueAxisX.renderer.cellEndLocation = 0.9;
        },

        /**
         * @param {String} value
         * @param {String} name
         * @private
         * @returns {Object}
         */
        _createSeries: function (value, name) {
            var series = this.chart.series.push(new amcharts.ColumnSeries());

            series.dataFields.valueAxisY = value;
            series.dataFields.valueAxisX = 'category';
            series.name = name;

            return series;
        }
    };

    return {
        /**
         * @public
         * @param {Object} node
         * @returns {void}
         */
        init: function (node) {
            this.chart = window.am4core.create(node, amcharts.XYChart);

            this.initScrollbar();
            this.initLegend();
        },

        /**
         * @public
         * @param {Object} response
         * @returns {void}
         */
        update: function (response) {
            model._initSeries.call(this);
            model._initAxis.call(this, 'x', response.xAxisType);
            model._initAxis.call(this, 'y', response.yAxisType);
            model._renderChart.call(this);
        }
    };
});
