define([
    'mage/translate',
    'Amasty_ReportBuilder/js/charts/types/linear',
    'Amasty_ReportBuilderCharts/js/charts/types/pie',
    'Amasty_ReportBuilderCharts/js/charts/types/simple-column',
    'Amasty_ReportBuilderCharts/js/charts/types/sorted-bar'
], function ($t, linear, pie, simpleColumn, sortedBar) {
    'use strict';

    var description = [
        {
            'value': 'linear',
            'label': $t('Linear Chart'),
            'axises': [
                {
                    id: '',
                    type: 'x',
                    label: 'X-axis'
                },
                {
                    id: '',
                    type: 'y',
                    label: 'Y-axis'
                }
            ]
        },
        {
            'value': 'simplePie',
            'label': $t('Simple Pie Chart'),
            'axises': [
                {
                    id: '',
                    type: 'pie',
                    label: 'Pie Column'
                },
                {
                    id: '',
                    type: 'slice',
                    label: 'Slice Column'
                }
            ]
        },
        {
            'value': 'semiCirclePie',
            'label': $t('Semi-circle Pie Chart'),
            'axises': [
                {
                    id: '',
                    type: 'pie',
                    label: 'Pie Column'
                },
                {
                    id: '',
                    type: 'slice',
                    label: 'Slice Column'
                }
            ]
        },
        {
            'value': 'simpleColumn',
            'label': $t('Simple Column Chart'),
            'axises': [
                {
                    id: '',
                    type: 'x',
                    label: 'X-axis'
                },
                {
                    id: '',
                    type: 'y',
                    label: 'Y-axis'
                }
            ]
        },
        {
            'value': 'sortedBar',
            'label': $t('Sorted Bar Chart'),
            'axises': [
                {
                    id: '',
                    type: 'x',
                    label: 'X-axis'
                },
                {
                    id: '',
                    type: 'y',
                    label: 'Y-axis'
                }
            ]
        }
    ];

    return {
        'description': description,
        'linear': linear,
        'simplePie': pie,
        'semiCirclePie': pie,
        'simpleColumn': simpleColumn,
        'sortedBar': sortedBar
    };
});
