<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Custom Reports Builder for Magento 2
 */

namespace Amasty\ReportBuilder\Ui\Component\Listing\View\Columns\Adapter;

use Amasty\ReportBuilder\Api\Data\ReportColumnInterface;

interface AdapterInterface
{
    /**
     * Fulfill Ui component configuration
     *
     * @param ReportColumnInterface $reportColumn
     * @param array $config ui component configuration
     */
    public function modify(ReportColumnInterface $reportColumn, array &$config): void;
}
