<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2: Stripe (System)
 */

namespace Amasty\RecurringStripe\Plugin\Gateway\Helper;

use Amasty\RecurringPayments\Model\QuoteValidate;
use Magento\Checkout\Model\Session as CheckoutSession;

class AmountHelper
{
    public const STRIPE_MIN_AMOUNT = 50;

    /**
     * @var CheckoutSession
     */
    private $checkoutSession;

    /**
     * @var QuoteValidate
     */
    private $quoteValidate;

    public function __construct(
        CheckoutSession $checkoutSession,
        QuoteValidate $quoteValidate
    ) {
        $this->checkoutSession = $checkoutSession;
        $this->quoteValidate = $quoteValidate;
    }

    /**
     * @param \Amasty\Stripe\Gateway\Helper\AmountHelper $subject
     * @param float|int $result
     * @return float|int
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetAmountForStripe(\Amasty\Stripe\Gateway\Helper\AmountHelper $subject, $result)
    {
        $quote = $this->checkoutSession->getQuote();

        if ($quote->getGrandTotal() > 0.0001 || !$this->quoteValidate->validateQuote($quote)) {
            return $result;
        }

        return self::STRIPE_MIN_AMOUNT;
    }
}
